<?php
/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
include_once "templates/base.php";

require_once realpath(dirname(__FILE__) . '/../src/Google/autoload.php');

/************************************************
  ATTENTION: Fill in these values! Make sure
  the redirect URI is to this page, e.g:
  http://localhost:8080/user-example.php
 ************************************************/
$user_ip        = isset( $_SERVER['REMOTE_ADDR'] ) ? $_SERVER['REMOTE_ADDR']: false;

$client_id      = '<YOUR_CLIENT_ID>';
$client_secret  = '<YOUR_CLIENT_SECRET>';
$redirect_uri   = '<YOUR_REDIRECT_URI>';

$client         = new Google_Client();
$client->setClientId($client_id);
$client->setClientSecret($client_secret);
$client->setRedirectUri($redirect_uri);
$client->setScopes('email');

/************************************************
  If we're logging out we just need to clear our
  local access token in this case
 ************************************************/
if ( isset( $_REQUEST[ 'logout' ] ) ) {
  delete_transient( 'jnews_social_login_' . $user_ip . '_access_token' );
}

/************************************************
  If we have a code back from the OAuth 2.0 flow,
  we need to exchange that with the authenticate()
  function. We store the resultant access token
  bundle in the session, and redirect to ourself.
 ************************************************/
if ( isset( $_GET[ 'code' ] ) ) {
  $client->authenticate($_GET['code']);
  set_transient( 'jnews_social_login_' . $user_ip . '_access_token', $client->getAccessToken(), HOUR_IN_SECONDS );
  $redirect = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];
  header('Location: ' . filter_var($redirect, FILTER_SANITIZE_URL));
}

/************************************************
  If we have an access token, we can make
  requests, else we generate an authentication URL.
 ************************************************/
if ( ! empty( get_transient( 'jnews_social_login_' . $user_ip . '_access_token' ) ) ) {
  $client->setAccessToken( get_transient( 'jnews_social_login_' . $user_ip . '_access_token' ) );
} else {
  $authUrl = $client->createAuthUrl();
}

/************************************************
  If we're signed in we can go ahead and retrieve
  the ID token, which is part of the bundle of
  data that is exchange in the authenticate step
  - we only need to do a network call if we have
  to retrieve the Google certificate to verify it,
  and that can be cached.
 ************************************************/
if ( $client->getAccessToken() ) {
  set_transient( 'jnews_social_login_' . $user_ip . '_access_token', $client->getAccessToken(), HOUR_IN_SECONDS );
  $token_data = $client->verifyIdToken()->getAttributes();
}

echo pageHeader( "User Query - Retrieving An Id Token" );
if ( strpos( $client_id, "googleusercontent" ) == false ) {
  echo missingClientSecretsWarning();
  exit;
}
?>
<div class="box">
  <div class="request">
<?php
if ( isset( $authUrl ) ) {
  echo "<a class='login' href='" . $authUrl . "'>Connect Me!</a>";
} else {
  echo "<a class='logout' href='?logout'>Logout</a>";
}
?>
  </div>

  <div class="data">
<?php 
if ( isset( $token_data ) ) {
  var_dump( $token_data );
}
?>
  </div>
</div>
<?php
echo pageFooter(__FILE__);
